﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using System.Collections.Generic;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    [TestClass]
    public class MilitaryOccupationHistoryManagerTests
    {
        private MilitaryOccupationHistoryManager _cut;

        [TestInitialize()]
        public void MyTestInitialize()
        {
            _cut = new MilitaryOccupationHistoryManager("Data Source=DNS  ; Initial Catalog=Registry_AHOBPRHRE;Integrated Security=True;Encrypt=yes");
        }
        [TestMethod]
        public void CreateOccupationHistory_Returns_Correct_Number_Of_Entries()
        {
            var actual = _cut.GetRegistrantHistory("6001010001");
            Assert.AreEqual(8, actual.Keys.Count);
        }

        [TestMethod]
        public void CreateOccupationHistory_Returns_Five_Entries()
        {
            var actual = _cut.GetRegistrantHistory("1005136624");
            Assert.AreEqual(5, actual.Keys.Count);
        }
        [TestMethod]
        public void CreateOccupationHistory_Returns_Eight_Entries()
        {
            var actual = _cut.GetRegistrantHistory("1293307390");
            Assert.AreEqual(7, actual.Keys.Count);
        }
        

    }
}
